// NewOutputDialog.cpp : implementation file
//

#include "stdafx.h"
#include "script.h"
#include "NewOutputDialog.h"
#include "outputwindow.h"
#include "IntrinsicControl.h"

#undef _DEBUG // EMP DIKEO


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern BOOL gbScriptRunning;


/////////////////////////////////////////////////////////////////////////////
// CNewOutputDialog dialog


CNewOutputDialog::CNewOutputDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CNewOutputDialog::IDD, pParent)
{
	EnableAutomation();

	//{{AFX_DATA_INIT(CNewOutputDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CNewOutputDialog::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CDialog::OnFinalRelease();
}

void CNewOutputDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNewOutputDialog)
	DDX_Control(pDX, IDC_EDIT1, m_EditControl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNewOutputDialog, CDialog)
	//{{AFX_MSG_MAP(CNewOutputDialog)
	ON_WM_DESTROY()
	ON_WM_SETFOCUS()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CNewOutputDialog, CDialog)
	//{{AFX_DISPATCH_MAP(CNewOutputDialog)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_INewOutputDialog to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {C3F29AF5-9854-11D2-89B8-0000E73336C3}
static const IID IID_INewOutputDialog =
{ 0xc3f29af5, 0x9854, 0x11d2, { 0x89, 0xb8, 0x0, 0x0, 0xe7, 0x33, 0x36, 0xc3 } };


BEGIN_INTERFACE_MAP(CNewOutputDialog, CDialog)
	INTERFACE_PART(CNewOutputDialog, IID_INewOutputDialog, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNewOutputDialog message handlers
/////////////////////////////////////////////////////////////////////////////
// CNewOutputDialog message handlers
BOOL CNewOutputDialog::OnInitDialog() 
{
//   AfxMessageBox( _T( "OnInitDialog" ) );
	RECT rectParent,rectClient;
	CDialog::OnInitDialog();


	
	GetParent()->GetClientRect(&rectParent);
	//**JULY99 - move right edge out one pixel..
   //** MARCH2K - Do this a little bit smarter
//   if( rectParent.right % 2 )
//      rectParent.right += 1;
//   if( rectParent.bottom % 2 )
//      rectParent.bottom += 1;


#ifndef _POCKET
	rectParent.top+=CommandBar_Height(((CFrameWnd *)GetParent())->m_hCommandBar);
#endif

	//this resizes the window, but doesn't seem to actually move it.  We move it again
	//in the calling function (the function that opens this dialog).  We have to resize the
	//window here, or the children won't be sized correctly.
	SetWindowPos(&wndTop,rectParent.left,rectParent.top,rectParent.right-rectParent.left,rectParent.bottom-rectParent.top,SWP_NOCOPYBITS|SWP_NOACTIVATE);

	GetClientRect(&rectClient);
	
//CString temp;
//temp.Format( _T("Client: %d %d"), rectClient.right, rectClient.bottom );
//AfxMessageBox( temp );
	
	++rectClient.bottom;
	m_PictureBox2.MoveWindow(&rectClient,true);
	--rectClient.bottom;

	m_EditControl.MoveWindow(&rectClient,false);
	m_EditControl.ShowWindow(SW_HIDE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CNewOutputDialog::myMoveWindow(RECT *pRect)
{
	RECT rectClient;

	MoveWindow(pRect);
	GetClientRect(&rectClient);

   // PictureBox shows a blank line around lower and right edges
   rectClient.bottom += 1;
   rectClient.right += 1;

   m_PictureBox2.MoveWindow(&rectClient,true);
   rectClient.bottom -= 1;
   rectClient.right -= 1;

   m_EditControl.MoveWindow(&rectClient,false);
}

void CNewOutputDialog::OnCancel()
{
	return;
	//IUnknown *pUnk;
	//DebugStr(L"OnCancel");

	//pUnk=m_PictureBox.GetControlUnknown();
	//DebugRefCount(pUnk,L"OutputDialog PictureBox just prior to destruction");
	DestroyWindow();
	
}

void CNewOutputDialog::OnOK()
{
	return;
}

void CNewOutputDialog::OnDestroy() 
{
//	class COutputWindow *pParent = (COutputWindow *)GetParent();
//	pParent->pEngine->m_bQueryUnloadCancel = false;
//	pParent->pEngine->SendScriptMessage( _T("output_queryunload"), VT_EMPTY, 0, 0 );
//	if( pParent->pEngine->m_bQueryUnloadCancel )
	CDialog::OnDestroy();
}

BOOL CNewOutputDialog::PreCreateWindow(CREATESTRUCT& cs) 
{
	BOOL retval=CDialog::PreCreateWindow(cs);
		
	cs.dwExStyle|=WS_EX_NOANIMATION;
	return retval;
}

BOOL CNewOutputDialog::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	//goto xxx;


	switch(pMsg->message)
	{
	case WM_KEYDOWN:
	case WM_KEYUP:
	case WM_SYSKEYDOWN:
	case WM_SYSKEYUP:
		{
			class COutputWindow * pParent;
			unsigned char parms[]=VTS_I4 VTS_I4;
			int iShift=0;
			pParent=(COutputWindow *)GetParent();
			if(pParent->m_bKeyPreview)
			{
				iShift|=(GetKeyState(VK_SHIFT)&0x80)?0x01:0x00;
				iShift|=(GetKeyState(VK_CONTROL)&0x80)?0x02:0x00;
				iShift|=(GetKeyState(VK_MENU)&0x80)?0x04:0x00;

				pParent->pEngine->SendScriptMessage((pMsg->message==WM_KEYDOWN || pMsg->message==WM_SYSKEYDOWN)?TEXT("output_keydown"):TEXT("output_keyup"),VT_EMPTY,0,parms,(int)pMsg->wParam,iShift);
			}
			break;
		}
	case WM_SYSCHAR:
	case WM_CHAR:
		{
			class COutputWindow * pParent;
			unsigned char parms[]=VTS_I4;

			pParent=(COutputWindow *)GetParent();

			if(pParent->m_bKeyPreview)
				pParent->pEngine->SendScriptMessage(TEXT("output_keypress"),VT_EMPTY,0,parms,(TCHAR)pMsg->wParam);
			break;
		}
	case WM_SETFOCUS:
		{
			m_PictureBox2.SetFocus();
			break;
		}
	}//switch
//xxx
	return CDialog::PreTranslateMessage(pMsg);
}

long CNewOutputDialog::OnCtlColorBtn(DWORD wParam, DWORD lParam)
{
	::SetBkColor((HDC)wParam,RGB(128,128,128));
	::SetTextColor((HDC)wParam,RGB(0,0,0)); //focus rectangle for button should be same color as background.
	return (long) GetStockObject(NULL_BRUSH);
}

long CNewOutputDialog::OnCtlColorListBox(DWORD wParam, DWORD lParam)
{
	::SetBkColor((HDC)wParam,RGB(128,128,128));
	::SetTextColor((HDC)wParam,RGB(0,0,0));
	return (long) GetStockObject(NULL_BRUSH);
}

long CNewOutputDialog::OnCtlColorEdit(DWORD wParam, DWORD lParam)
{
	return OnCtlColorListBox(wParam,lParam);
}

long CNewOutputDialog::OnCtlColorStatic(DWORD wParam, DWORD lParam)
{
	return OnCtlColorListBox(wParam,lParam);
}

long CNewOutputDialog::OnCtlColorScrollBar(DWORD wParam, DWORD lParam)
{
	return OnCtlColorListBox(wParam,lParam);
}
void CNewOutputDialog::OnSetFocus( CWnd* pOldWnd )
{
	m_PictureBox2.SetFocus();
	CIntrinsicControl::Refocus();
}

BEGIN_EVENTSINK_MAP(CNewOutputDialog, CDialog)
    //{{AFX_EVENTSINK_MAP(CNewOutputDialog)
// DIKEO	ON_EVENT(CNewOutputDialog, IDC_PICTUREBOX1, 7 /* KeyPress */, OnKeyPressPicturebox, VTS_I4)
// DIKEO	ON_EVENT(CNewOutputDialog, IDC_PICTUREBOX1, 6 /* KeyUp */, OnKeyUpPicturebox, VTS_I4 VTS_I4)
// DIKEO	ON_EVENT(CNewOutputDialog, IDC_PICTUREBOX1, 5 /* KeyDown */, OnKeyDownPicturebox, VTS_I4 VTS_I4)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CNewOutputDialog::OnKeyPressPicturebox(long KeyASCII) 
{
	class COutputWindow * pParent;
	unsigned char parms[]=VTS_I4;

	pParent=(COutputWindow *)GetParent();

	if(pParent->m_bKeyPreview)
		pParent->pEngine->SendScriptMessage(TEXT("output_keypress"),VT_EMPTY,0,parms,KeyASCII);
}

void CNewOutputDialog::OnKeyUpPicturebox(long KeyCode, long Shift) 
{
	class COutputWindow * pParent;
	unsigned char parms[]=VTS_I4 VTS_I4;

	pParent=(COutputWindow *)GetParent();
	if(pParent->m_bKeyPreview)
	{
		pParent->pEngine->SendScriptMessage(TEXT("output_keyup"),VT_EMPTY,0,parms,KeyCode,Shift);
	}
}

void CNewOutputDialog::OnKeyDownPicturebox(long KeyCode, long Shift) 
{
	class COutputWindow * pParent;
	unsigned char parms[]=VTS_I4 VTS_I4;

	pParent=(COutputWindow *)GetParent();
	if(pParent->m_bKeyPreview)
	{
		pParent->pEngine->SendScriptMessage(TEXT("output_keydown"),VT_EMPTY,0,parms,KeyCode,Shift);
	}
}

void CNewOutputDialog::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if( pScrollBar
	&& ( ( ( (CIntrinsicControl *)pScrollBar )->m_pioThis->ictType == IntrinsicHScrollBar )
	   || ( ( (CIntrinsicControl *)pScrollBar )->m_pioThis->ictType == IntrinsicVScrollBar ) ) )
		( (CIntrinsicControl *)pScrollBar )->SendMessage( WM_HSCROLL, MAKEWPARAM( WORD(nSBCode), WORD(nPos) ), 0 );
}

void CNewOutputDialog::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if( pScrollBar
		&& ( ( ( (CIntrinsicControl *)pScrollBar )->m_pioThis->ictType == IntrinsicHScrollBar )
			|| ( ( (CIntrinsicControl *)pScrollBar )->m_pioThis->ictType == IntrinsicVScrollBar ) ) )
		( (CIntrinsicControl *)pScrollBar )->SendMessage( WM_VSCROLL, MAKEWPARAM( WORD(nSBCode), WORD(nPos) ), 0 );
}

/*
void CNewOutputDialog::OnClose() 
{
	class COutputWindow *pParent = (COutputWindow *)GetParent();
	pParent->pEngine->m_bQueryUnloadCancel = false;
	pParent->pEngine->SendScriptMessage( _T("output_queryunload"), VT_EMPTY, 0, 0 );
	if( pParent->pEngine->m_bQueryUnloadCancel )
		CDialog::OnClose();
}
*/
